<?php
require_once '../config/db.php';
// جلب الإعدادات
$settings = [];
$stmt = $pdo->query('SELECT key_name, value FROM settings');
foreach ($stmt as $row) {
    $settings[$row['key_name']] = $row['value'];
}
// جلب المشاريع
$projects = $pdo->query('SELECT * FROM projects ORDER BY id DESC LIMIT 6')->fetchAll();
// إحصائيات المشاريع
$total_projects = $pdo->query('SELECT COUNT(*) FROM projects')->fetchColumn();
$completed_projects = $pdo->query("SELECT COUNT(*) FROM projects WHERE status = 'مكتمل'")->fetchColumn();
$in_progress_projects = $pdo->query("SELECT COUNT(*) FROM projects WHERE status = 'تحت الانشاء'")->fetchColumn();
$sold_projects = $pdo->query("SELECT COUNT(*) FROM projects WHERE status = 'تم البيع'")->fetchColumn();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($settings['company_name'] ?? 'الموقع العقاري') ?></title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: <?= $settings['bg_color'] ?? '#EEEEEE' ?>; font-family: 'Cairo', sans-serif; }
        .navbar { background: <?= $settings['main_color'] ?? '#EA9218' ?>; color: #fff; padding: 12px 0; display: flex; align-items: center; justify-content: space-between; }
        .navbar img { height: 48px; margin-right: 16px; }
        .navbar ul { list-style: none; display: flex; gap: 24px; margin: 0; padding: 0; }
        .navbar li { display: inline; }
        .navbar a { color: #fff; text-decoration: none; font-weight: bold; font-size: 18px; }
        .banner { background: <?= $settings['secondary_color'] ?? '#3A4750' ?>; color: #fff; padding: 48px 0; text-align: center; }
        .banner h1 { font-size: 36px; margin-bottom: 16px; }
        .banner .search { margin: 24px auto; max-width: 400px; }
        .stats { display: flex; gap: 24px; justify-content: center; margin: 32px 0; }
        .stat-card { background: #fff; color: <?= $settings['main_color'] ?? '#EA9218' ?>; border-radius: 8px; box-shadow: 0 0 8px #31384122; padding: 24px; min-width: 160px; text-align: center; font-size: 20px; flex: 1; cursor: pointer; transition: box-shadow 0.2s; }
        .stat-card:hover { box-shadow: 0 0 16px #EA9218; }
        .projects-section { max-width: 1100px; margin: 0 auto 48px; }
        .projects-title { color: <?= $settings['main_color'] ?? '#EA9218' ?>; font-size: 28px; margin-bottom: 24px; text-align: center; }
        .project-cards { display: flex; flex-wrap: wrap; gap: 24px; justify-content: center; }
        .project-card { background: #fff; border-radius: 8px; box-shadow: 0 0 8px #31384122; padding: 16px; min-width: 220px; max-width: 300px; text-align: center; position: relative; }
        .project-card .status { position: absolute; top: 8px; left: 8px; background: <?= $settings['main_color'] ?? '#EA9218' ?>; color: #fff; padding: 4px 12px; border-radius: 6px; font-size: 14px; }
        .project-card h3 { color: <?= $settings['secondary_color'] ?? '#3A4750' ?>; margin-bottom: 8px; }
        .project-card .location { color: <?= $settings['text_color'] ?? '#313841' ?>; font-size: 15px; margin-bottom: 8px; }
        .project-card .units { color: #EA9218; font-size: 14px; margin-bottom: 8px; }
        .project-card .price { color: #3A4750; font-size: 16px; margin-bottom: 8px; }
        .project-card .actions { margin-top: 12px; display: flex; gap: 8px; justify-content: center; }
        .project-card .btn { background: #EA9218; color: #fff; border: none; padding: 6px 16px; border-radius: 4px; cursor: pointer; font-size: 14px; text-decoration: none; }
        .contact-section { background: #fff; border-radius: 8px; box-shadow: 0 0 8px #31384122; max-width: 700px; margin: 0 auto 32px; padding: 32px; }
        .contact-title { color: #EA9218; font-size: 22px; margin-bottom: 16px; text-align: center; }
        .contact-info { margin-bottom: 16px; text-align: center; }
        .contact-info span { display: block; margin-bottom: 6px; color: #3A4750; }
        .contact-form label { color: #3A4750; font-weight: bold; }
        .contact-form input, .contact-form textarea { width: 100%; padding: 8px; margin-bottom: 12px; border: 1px solid #EA9218; border-radius: 4px; }
        .contact-form button { background: #EA9218; color: #fff; border: none; padding: 10px 24px; border-radius: 4px; width: 100%; font-size: 16px; }
        .footer { background: <?= $settings['secondary_color'] ?? '#3A4750' ?>; color: #fff; padding: 24px 0; text-align: center; margin-top: 48px; }
        .footer img { height: 40px; margin-bottom: 8px; }
    </style>
</head>
<body>
    <!-- النافبار -->
    <nav class="navbar">
        <div>
            <img src="../assets/<?= htmlspecialchars($settings['logo'] ?? 'logo.png') ?>" alt="شعار الشركة">
        </div>
        <ul>
            <li><a href="index.php">الرئيسية</a></li>
            <li><a href="projects.php">المشاريع</a></li>
            <li><a href="about.php">من نحن</a></li>
            <li><a href="contact.php">تواصل معنا</a></li>
            <li><a href="#" onclick="alert('قريباً!');">تغيير اللغة</a></li>
        </ul>
    </nav>
    <!-- البانر -->
    <div class="banner">
        <h1>مرحبا بكم في <?= htmlspecialchars($settings['company_name'] ?? 'شركتنا العقارية') ?></h1>
        <div class="search">
            <input type="text" placeholder="ابحث عن مشروع..." style="width:80%;padding:8px;border-radius:4px;border:1px solid #EA9218;">
        </div>
        <div class="stats">
            <div class="stat-card" onclick="window.location='projects.php';">
                <div>إجمالي المشاريع</div>
                <div><?= $total_projects ?></div>
            </div>
            <div class="stat-card" onclick="window.location='projects.php?status=مكتمل';">
                <div>مشاريع مكتملة</div>
                <div><?= $completed_projects ?></div>
            </div>
            <div class="stat-card" onclick="window.location='projects.php?status=تحت الانشاء';">
                <div>تحت الإنشاء</div>
                <div><?= $in_progress_projects ?></div>
            </div>
            <div class="stat-card" onclick="window.location='projects.php?status=تم البيع';">
                <div>تم البيع</div>
                <div><?= $sold_projects ?></div>
            </div>
        </div>
    </div>
    <!-- أحدث المشاريع -->
    <div class="projects-section">
        <div class="projects-title">أحدث المشاريع</div>
        <div class="project-cards">
            <?php foreach ($projects as $project): ?>
            <div class="project-card">
                <div class="status"> <?= $project['status'] ?> </div>
                <h3><?= htmlspecialchars($project['name']) ?></h3>
                <div class="location"> <?= htmlspecialchars($project['location']) ?> </div>
                <div class="units">عدد الوحدات: <?= $project['units_count'] ?> </div>
                <div class="price">السعر: <?= $project['price_from'] ?> - <?= $project['price_to'] ?> ريال</div>
                <div class="actions">
                    <a class="btn" href="project_details.php?id=<?= $project['id'] ?>">تفاصيل المشروع</a>
                    <?php if (!empty($project['brochure'])): ?>
                        <a class="btn" href="../uploads/<?= htmlspecialchars($project['brochure']) ?>" target="_blank">تحميل الكتيب</a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <!-- معلومات التواصل -->
    <div class="contact-section">
        <div class="contact-title">معلومات التواصل</div>
        <div class="contact-info">
            <span>الهاتف: <?= htmlspecialchars($settings['phone'] ?? '') ?></span>
            <span>الإيميل: <?= htmlspecialchars($settings['email'] ?? '') ?></span>
            <span>واتساب: <?= htmlspecialchars($settings['whatsapp'] ?? '') ?></span>
            <span>العنوان: <?= htmlspecialchars($settings['address'] ?? '') ?></span>
            <span>أوقات العمل: <?= htmlspecialchars($settings['work_hours'] ?? '') ?></span>
        </div>
        <form class="contact-form" method="post" action="contact.php">
            <label>الاسم</label>
            <input type="text" name="name" required>
            <label>البريد الإلكتروني</label>
            <input type="email" name="email" required>
            <label>الهاتف</label>
            <input type="text" name="phone" required>
            <label>رسالتك</label>
            <textarea name="message" rows="3" required></textarea>
            <button type="submit">إرسال</button>
        </form>
    </div>
    <!-- الفوتر -->
    <footer class="footer">
        <?php if (!empty($settings['logo'])): ?>
            <img src="../assets/<?= htmlspecialchars($settings['logo']) ?>" alt="شعار الشركة">
        <?php endif; ?>
        <div><?= htmlspecialchars($settings['company_name'] ?? 'شركتنا العقارية') ?></div>
        <div>جميع الحقوق محفوظة &copy; <?= date('Y') ?></div>
    </footer>
</body>
</html>
